/**
 * Copyright Notice
 * 
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * CommonMenuBuilderI
 * 
 * @author <a href="mailto:joel.kniaz@gmail.com">Joel Kniaz</a>
 */
package gov.va.isaac.util;

import gov.va.isaac.util.CommonMenus.CommonMenuItem;
import gov.va.isaac.util.CommonMenus.MergeMode;
import javafx.beans.property.BooleanProperty;

/**
 * CommonMenuBuilderI
 * 
 * @author <a href="mailto:joel.kniaz@gmail.com">Joel Kniaz</a>
 *
 */
public interface CommonMenuBuilderI {
	public abstract CommonMenuItem[] getMenuItemsToExclude();

	public abstract void setMenuItemsToExclude(
			CommonMenuItem... menuItemsToExclude);

	public abstract MergeMode getMergeMode();

	public abstract void setMergeMode(MergeMode mergeMode);

	public abstract BooleanProperty getInvisibleWhenfalse();

	public abstract void setInvisibleWhenFalse(
			BooleanProperty invisibleWhenfalse);
}